#!/bin/bash

root="$( cd "$(dirname "${BASH_SOURCE[0]}")" && pwd )"

# parse necessary information from command line if available
while [[ $# > 1 ]]
do
    key="$1"

    case $key in
        -u|--user)
        user="$2"
        shift
        ;;
        -e|--email)
        email="$2"
        shift
        ;;
        -p|--password)
        password="$2"
        shift
        ;;
        *)
        # unknown option
        ;;
    esac
    shift
done

if [[ -z "$user" ]]
then
    user=
    while [[ $user = "" ]]; do
        read -p "Username: " user
    done
fi

if [[ -z "$email" ]]
then
    email=
    while [[ $email = "" ]]; do
        read -p "Email address: " email
    done
fi

if [[ -z "$password" ]]
then
    stty -echo
    password=
    while [[ $password = "" ]]; do
        read -p "Password: " password
    done
    stty echo
fi

hash=$(echo "$password" | java -cp "$root" BCrypt)

mkdir -p "$root/users/$user"
sed -e "s/@USER@/$user/g;s/@EMAIL@/$email/g;s<@PASSWORD_HASH@<$hash<g" "$root/user-config.xml.in" > "$root/users/$user/config.xml"
